/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.common.util.Messages;
import com.jrockit.mc.common.util.TimeRangeToolkit;
import com.jrockit.mc.ui.model.fields.NumberField;
import com.jrockit.mc.ui.model.fields.TimespanParser;
import java.text.NumberFormat;
import java.text.ParseException;

public class TimeSpanField
extends NumberField {
    private static final String SECONDS = String.valueOf(' ') + Messages.getString((String)"TimeRangeToolkit_SECONDS_SHORT", (String)"s");
    private static final String NO_TIME_SPAN = "0" + SECONDS;
    private static final int MILLIS_PER_SECOND = 1000;
    protected static final NumberFormat millisFractionFormat = NumberFormat.getInstance();
    private final int m_digits;

    static {
        millisFractionFormat.setMaximumFractionDigits(3);
        millisFractionFormat.setMinimumFractionDigits(3);
    }

    public TimeSpanField(int id) {
        this(id, 3);
    }

    public TimeSpanField(int id, int digits) {
        super(id);
        this.m_digits = digits;
    }

    @Override
    public String formatObject(Object object) {
        if (object instanceof Number) {
            Number time = (Number)object;
            if (!TimeSpanField.isValid(time)) {
                return super.formatObject(null);
            }
            return this.formatTimeSpan(time);
        }
        return super.formatObject(object);
    }

    private String formatTimeSpan(Number number) {
        if (number.doubleValue() == 0.0) {
            return NO_TIME_SPAN;
        }
        return TimeRangeToolkit.convertMillisToString((long)number.longValue());
    }

    @Override
    public String formatForClipboard(Object object) {
        if (object instanceof Number && TimeSpanField.isValid((Number)object)) {
            if (object instanceof Double) {
                return NumberField.formatNumberForClipboardWithPrecision((Number)object, 9);
            }
            return NumberField.formatNumberForClipboardWithPrecision((Number)object, this.m_digits);
        }
        return super.formatForClipboard(null);
    }

    @Override
    public String getUnit() {
        return "ms";
    }

    @Override
    public String getTooltip(Object object) {
        if (object instanceof Number && TimeSpanField.isValid((Number)object)) {
            return String.valueOf(millisFractionFormat.format(((Number)object).doubleValue() / 1000.0)) + SECONDS;
        }
        return null;
    }

    @Override
    public Object parse(Tokenizer tokenizer) throws ParseException {
        Long nanos = TimespanParser.parse(tokenizer);
        if (nanos != null) {
            return nanos / 1000000L;
        }
        return null;
    }
}

