/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application.scripting.model;

import com.jrockit.mc.rcp.application.scripting.model.Line;
import com.jrockit.mc.rcp.application.scripting.model.Program;
import java.io.PrintStream;
import java.util.Observable;

public final class Process
extends Observable {
    private final PrintStream m_standardOut;
    private final PrintStream m_errorOut;
    private final Program m_program = new Program();
    private int m_instructionPointer = 0;
    private boolean m_singleStep = false;
    private boolean m_running = false;
    private boolean m_repeating = false;

    public Process() {
        this(System.out, System.err);
    }

    Process(PrintStream standardOut, PrintStream errorOut) {
        this.m_standardOut = standardOut;
        this.m_errorOut = errorOut;
    }

    public void start() {
        this.m_instructionPointer = 0;
        this.m_running = true;
        this.setChanged();
        this.notifyObservers();
    }

    public void resume() {
        this.m_running = true;
        this.setChanged();
        this.notifyObservers();
    }

    public void stop() {
        this.m_running = false;
        this.m_singleStep = true;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isRunning() {
        return this.m_running;
    }

    public int getInstructionPointer() {
        return this.m_instructionPointer;
    }

    public Line getInstruction() {
        return this.m_program.getLine(this.m_instructionPointer);
    }

    public PrintStream getStandardOut() {
        return this.m_standardOut;
    }

    public PrintStream getErrorOut() {
        return this.m_errorOut;
    }

    public void setSingleStep(boolean singleStep) {
        this.m_running = true;
        this.m_singleStep = singleStep;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isSingleStep() {
        return this.m_singleStep;
    }

    public boolean hasMoreinstuctions() {
        return this.m_instructionPointer < this.m_program.getLineCount();
    }

    public void terminate() {
        this.stop();
        this.m_instructionPointer = 0;
        this.setChanged();
        this.notifyObservers();
    }

    public void nextInstruction() {
        ++this.m_instructionPointer;
        if (!this.hasMoreinstuctions() && this.isRepeating()) {
            this.m_instructionPointer = 0;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public Program getProgram() {
        return this.m_program;
    }

    public void setRepeating(boolean repeating) {
        this.m_repeating = repeating;
    }

    protected boolean isRepeating() {
        return this.m_repeating;
    }

    public void setCurrentLine(int line) {
        this.m_instructionPointer = line;
        this.setChanged();
        this.notifyObservers();
    }
}

