/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.CompositeInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.IntegerInput;
import com.jrockit.mc.components.ui.settings.OrientationInput;
import com.jrockit.mc.components.ui.settings.TabFolderInput;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnViewConfigurer;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramInput;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.inputs.RepositoryCompatibleAttributeInput;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;

public class HistogramConfigurer
extends ColumnViewConfigurer {
    @Override
    protected IInput createInput() {
        TabFolderInput tfi = new TabFolderInput();
        tfi.addInput(this.createGeneral());
        tfi.addInput(this.createColumns());
        tfi.addInput(this.createGroupBy());
        return tfi;
    }

    protected IInput createGeneral() {
        CompositeInput ci = new CompositeInput(Messages.COMPONENT_GENERAL_TITLE);
        ci.addInput(InputFactory.createRole(new Role[0]));
        ci.addInput(this.createShowTable());
        ci.addInput(this.createShowPieChart());
        ci.addInput(this.createPieChartPosition());
        ci.addInput(this.createMaximumCount());
        ci.addInput(InputFactory.createOperativeSetEnabled());
        ci.addInput(InputFactory.createIcon());
        return ci;
    }

    protected IInput createColumns() {
        HistogramInput ci = new HistogramInput(this.getServiceLocator(), this.getRepository());
        ci.addInput(InputFactory.createEmphasized());
        ci.addInput(InputFactory.createVisible());
        ci.addInput(InputFactory.createFilter(this.getRepository().getColumnDescriptors()));
        ci.addInput(InputFactory.createInitiallySorted(this.getRepository().getColumnDescriptors()));
        ci.addInput(InputFactory.createNormalized());
        ci.addInput(InputFactory.createBackdrop());
        ci.addInput(InputFactory.createAttributeWithRepository(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorRepository(), true));
        ci.addInput((IInput)InputFactory.createName());
        ci.addInput(InputFactory.createDescription());
        ci.addInput(InputFactory.createPreferredSortOrder());
        ci.addInput(InputFactory.createColumnWeightFactor());
        ci.addInput(InputFactory.createMinimumWidth());
        ci.addInput(InputFactory.createAggregator());
        ci.addInput(InputFactory.createUnit(false));
        return ci;
    }

    protected IInput createGroupBy() {
        CompositeInput ci = new CompositeInput(Messages.HISTOGRAM_CONFIGURATION_GROUP_BY_SPECIFIC_TITLE, "groupByColumn");
        ci.addInput(this.createGroupBy(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorRepository()));
        ci.addInput(this.createUserSelectable());
        ci.addInput(InputFactory.createColumnWeightFactor());
        ci.addInput(InputFactory.createMinimumWidth());
        ci.addInput(InputFactory.createUnit(false));
        ci.addInput((IInput)InputFactory.createName());
        ci.addInput(InputFactory.createDescription());
        return ci;
    }

    protected IInput createUserSelectable() {
        return new BooleanInput("userSelectableGroupBy", Messages.HISTOGRAM_CONFIGURATION_ALLOW_USER_CHANGE_INPUT_TEXT);
    }

    protected IInput createGroupBy(IServiceLocator locator, EventTypeDescriptorRepository e) {
        return new RepositoryCompatibleAttributeInput("groupBy", Messages.HISTOGRAM_CONFIGURATION_GROUP_BY_INPUT_TEXT, locator, e, true);
    }

    protected IInput createMaximumCount() {
        return new IntegerInput("maximumBucketCount", Messages.HISTOGRAM_CONFIGURATION_MAXIMUM_NUMBER_OF_BUCKETS_INPUT_TEXT, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
    }

    protected IInput createPieChartPosition() {
        return new OrientationInput("pieChartPosition", Messages.HISTOGRAM_CONFIGURATION_PIE_CHART_POSITION_INPUT_TEXT);
    }

    protected IInput createShowPieChart() {
        return new BooleanInput("showPieChart", Messages.HISTOGRAM_CONFIGURATION_SHOW_PIE_CHART_INPUT_TEXT);
    }

    protected IInput createShowTable() {
        return new BooleanInput("showTable", Messages.HISTOGRAM_CONFIGURATION_SHOW_TABLE_INPUT_TEXT);
    }

    @Override
    protected HistogramColumnDescriptorRepository getRepository() {
        return (HistogramColumnDescriptorRepository)this.getComponentSettings().getChildObject("columnDescriptorRepository", HistogramColumnDescriptorRepository.class);
    }
}

