/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.AllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.modules.profiler.api.GoToSource;

public class SnapshotAllocResultsPanel
extends AllocResultsPanel
implements ActionListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_GoSourcePopupItemName");
    private static final String SHOW_STACK_TRACES_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_ShowStackTracesPopupItemName");
    private AllocMemoryResultsSnapshot snapshot;
    private JMenuItem popupShowSource;
    private JMenuItem popupShowStacks;
    private JPopupMenu memoryResPopupMenu;

    public SnapshotAllocResultsPanel(AllocMemoryResultsSnapshot allocMemoryResultsSnapshot, MemoryResUserActionsHandler memoryResUserActionsHandler) {
        super(memoryResUserActionsHandler);
        this.snapshot = allocMemoryResultsSnapshot;
        this.fetchResultsFromSnapshot();
    }

    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.popupShowStacks) {
            this.actionsHandler.showStacksForClass(this.selectedClassId, this.getSortingColumn(), this.getSortingOrder());
        } else if (actionEvent.getSource() == this.popupShowSource && this.popupShowSource != null) {
            this.showSourceForClass(this.selectedClassId);
        }
    }

    @Override
    protected String getClassName(int n) {
        return this.snapshot.getClassName(n);
    }

    @Override
    protected String[] getClassNames() {
        return this.snapshot.getClassNames();
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (this.memoryResPopupMenu == null) {
            this.memoryResPopupMenu = new JPopupMenu();
            if (GoToSource.isAvailable()) {
                Font font = this.memoryResPopupMenu.getFont().deriveFont(1);
                this.popupShowSource = new JMenuItem();
                this.popupShowSource.setFont(font);
                this.popupShowSource.setText(GO_SOURCE_POPUP_ITEM_NAME);
                this.memoryResPopupMenu.add(this.popupShowSource);
                this.popupShowSource.addActionListener(this);
            }
            if (this.snapshot.containsStacks()) {
                if (GoToSource.isAvailable()) {
                    this.memoryResPopupMenu.addSeparator();
                }
                this.popupShowStacks = new JMenuItem();
                this.popupShowStacks.setText(SHOW_STACK_TRACES_POPUP_ITEM_NAME);
                this.memoryResPopupMenu.add(this.popupShowStacks);
                this.popupShowStacks.addActionListener(this);
            }
        }
        return this.memoryResPopupMenu;
    }

    private void fetchResultsFromSnapshot() {
        this.totalAllocObjectsSize = UIUtils.copyArray(this.snapshot.getObjectsSizePerClass());
        this.nTotalAllocObjects = UIUtils.copyArray(this.snapshot.getObjectsCounts());
        this.nTrackedItems = this.snapshot.getNProfiledClasses();
        if (this.nTrackedItems > this.nTotalAllocObjects.length) {
            this.nTrackedItems = this.nTotalAllocObjects.length;
        }
        if (this.nTrackedItems > this.totalAllocObjectsSize.length) {
            this.nTrackedItems = this.totalAllocObjectsSize.length;
        }
        this.maxValue = 0L;
        this.nTotalBytes = 0L;
        this.nTotalClasses = 0L;
        for (int i = 0; i < this.nTrackedItems; ++i) {
            if (this.maxValue < this.totalAllocObjectsSize[i]) {
                this.maxValue = this.totalAllocObjectsSize[i];
            }
            this.nTotalBytes += this.totalAllocObjectsSize[i];
            this.nTotalClasses += (long)this.nTotalAllocObjects[i];
        }
        this.initDataUponResultsFetch();
    }

    public void exportData(int n, ExportDataDumper exportDataDumper, String string) {
        this.percentFormat.setMinimumFractionDigits(2);
        this.percentFormat.setMaximumFractionDigits(2);
        switch (n) {
            case 1: {
                this.exportCSV(",", exportDataDumper);
                break;
            }
            case 2: {
                this.exportCSV(";", exportDataDumper);
                break;
            }
            case 3: {
                this.exportXML(exportDataDumper, string);
                break;
            }
            case 4: {
                this.exportHTML(exportDataDumper, string);
            }
        }
        this.percentFormat.setMaximumFractionDigits(1);
        this.percentFormat.setMinimumFractionDigits(0);
    }

    private void exportHTML(ExportDataDumper exportDataDumper, String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + string + "</TITLE></HEAD><BODY><TABLE border=\"1\"><tr>");
        for (n = 0; n < this.columnNames.length; ++n) {
            stringBuffer.append("<th>").append(this.columnNames[n]).append("</th>");
        }
        stringBuffer.append("</tr>");
        exportDataDumper.dumpData((CharSequence)stringBuffer);
        for (n = 0; n < this.nTrackedItems; ++n) {
            stringBuffer = new StringBuffer("<tr><td>" + this.replaceHTMLCharacters(this.sortedClassNames[n]) + "</td>");
            stringBuffer.append("<td align=\"right\">").append(this.percentFormat.format((double)this.totalAllocObjectsSize[n] / (double)this.nTotalBytes)).append("</td>");
            stringBuffer.append("<td align=\"right\">").append(this.totalAllocObjectsSize[n]).append("</td>");
            stringBuffer.append("<td align=\"right\">").append(this.nTotalAllocObjects[n]).append("</td></tr>");
            exportDataDumper.dumpData((CharSequence)stringBuffer);
        }
        exportDataDumper.dumpDataAndClose(new StringBuffer(" </TABLE></BODY></HTML>"));
    }

    private void exportXML(ExportDataDumper exportDataDumper, String string) {
        int n;
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string2 + "<ExportedView Name=\"" + string + "\">" + string2);
        stringBuffer.append(" <TableData NumRows=\"").append(this.nTrackedItems).append("\" NumColumns=\"4\">").append(string2).append("<TableHeader>");
        for (n = 0; n < this.columnNames.length; ++n) {
            stringBuffer.append("  <TableColumn><![CDATA[").append(this.columnNames[n]).append("]]></TableColumn>").append(string2);
        }
        stringBuffer.append("</TableHeader>");
        exportDataDumper.dumpData((CharSequence)stringBuffer);
        for (n = 0; n < this.nTrackedItems; ++n) {
            stringBuffer = new StringBuffer("  <TableRow>" + string2 + "   <TableColumn><![CDATA[" + this.sortedClassNames[n] + "]]></TableColumn>" + string2);
            stringBuffer.append("   <TableColumn><![CDATA[").append(this.percentFormat.format((double)this.totalAllocObjectsSize[n] / (double)this.nTotalBytes)).append("]]></TableColumn>").append(string2);
            stringBuffer.append("   <TableColumn><![CDATA[").append(this.totalAllocObjectsSize[n]).append("]]></TableColumn>").append(string2);
            stringBuffer.append("   <TableColumn><![CDATA[").append(this.nTotalAllocObjects[n]).append("]]></TableColumn>").append(string2).append("  </TableRow>").append(string2);
            exportDataDumper.dumpData((CharSequence)stringBuffer);
        }
        exportDataDumper.dumpDataAndClose(new StringBuffer(" </TableData>" + string2 + "</ExportedView>"));
    }

    private void exportCSV(String string, ExportDataDumper exportDataDumper) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\r\n";
        String string3 = "\"";
        for (n = 0; n < this.columnNames.length; ++n) {
            stringBuffer.append(string3).append(this.columnNames[n]).append(string3).append(string);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(string2);
        exportDataDumper.dumpData((CharSequence)stringBuffer);
        for (n = 0; n < this.nTrackedItems; ++n) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string3).append(this.sortedClassNames[n]).append(string3).append(string);
            stringBuffer.append(string3).append(this.percentFormat.format((double)this.totalAllocObjectsSize[n] / (double)this.nTotalBytes)).append(string3).append(string);
            stringBuffer.append(string3).append(this.totalAllocObjectsSize[n]).append(string3).append(string);
            stringBuffer.append(string3).append(this.nTotalAllocObjects[n]).append(string3).append(string2);
            exportDataDumper.dumpData((CharSequence)stringBuffer);
        }
        exportDataDumper.close();
    }

    private String replaceHTMLCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

