/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.treetable;

import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;

public class ExtendedTreeTableModel
extends AbstractTreeTableModel {
    private AbstractTreeTableModel realModel;
    private int[] columnsMapping;
    private boolean[] columnsVisibility;
    private int realColumnsCount;
    private int virtualColumnsCount;

    public ExtendedTreeTableModel(AbstractTreeTableModel abstractTreeTableModel) {
        super(abstractTreeTableModel.root, abstractTreeTableModel.supportsSorting, abstractTreeTableModel.initialSortingColumn, abstractTreeTableModel.initialSortingOrder);
        this.virtualColumnsCount = this.realColumnsCount = abstractTreeTableModel.getColumnCount();
        this.realModel = abstractTreeTableModel;
        this.columnsMapping = new int[this.realColumnsCount];
        boolean[] blArray = new boolean[this.realColumnsCount];
        for (int i = 0; i < this.realColumnsCount; ++i) {
            blArray[i] = true;
        }
        this.setColumnsVisibility(blArray);
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        return this.realModel.isCellEditable(object, this.getRealColumn(n));
    }

    @Override
    public Class getColumnClass(int n) {
        return this.realModel.getColumnClass(this.getRealColumn(n));
    }

    @Override
    public int getColumnCount() {
        return this.virtualColumnsCount;
    }

    @Override
    public String getColumnName(int n) {
        return this.realModel.getColumnName(this.getRealColumn(n));
    }

    @Override
    public String getColumnToolTipText(int n) {
        int n2 = this.getRealColumn(n);
        if (n2 == -1) {
            return null;
        }
        return this.realModel.getColumnToolTipText(n2);
    }

    public void setColumnsVisibility(boolean[] blArray) {
        this.columnsVisibility = blArray;
        this.recomputeColumnsMapping();
    }

    public boolean[] getColumnsVisibility() {
        return this.columnsVisibility;
    }

    @Override
    public boolean getInitialSorting(int n) {
        return this.realModel.getInitialSorting(this.getRealColumn(n));
    }

    @Override
    public int getInitialSortingColumn() {
        return this.realModel.getInitialSortingColumn();
    }

    @Override
    public boolean getInitialSortingOrder() {
        return this.realModel.getInitialSortingOrder();
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.realModel.isLeaf(object);
    }

    public int getRealColumn(int n) {
        if (n > -1 && n < this.columnsMapping.length) {
            return this.columnsMapping[n];
        }
        return -1;
    }

    public void setRealColumnVisibility(int n, boolean bl) {
        if (bl) {
            this.showRealColumn(n);
        } else {
            this.hideRealColumn(n);
        }
    }

    public boolean isRealColumnVisible(int n) {
        if (n > -1 && n < this.columnsMapping.length) {
            return this.columnsVisibility[n];
        }
        return false;
    }

    @Override
    public void setRoot(Object object) {
        this.realModel.setRoot(object);
    }

    @Override
    public Object getRoot() {
        return this.realModel.getRoot();
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
        this.realModel.setValueAt(object, object2, this.getRealColumn(n));
    }

    @Override
    public Object getValueAt(Object object, int n) {
        return this.realModel.getValueAt(object, this.getRealColumn(n));
    }

    public int getVirtualColumn(int n) {
        for (int i = 0; i < this.virtualColumnsCount; ++i) {
            if (this.getRealColumn(i) != n) continue;
            return i;
        }
        return -1;
    }

    public void hideRealColumn(int n) {
        if (this.isRealColumnVisible(n)) {
            this.columnsVisibility[n] = false;
            this.recomputeColumnsMapping();
        }
    }

    public void showRealColumn(int n) {
        if (!this.isRealColumnVisible(n)) {
            this.columnsVisibility[n] = true;
            this.recomputeColumnsMapping();
        }
    }

    @Override
    public void sortByColumn(int n, boolean bl) {
        this.realModel.sortByColumn(this.getRealColumn(n), bl);
    }

    private void recomputeColumnsMapping() {
        int n;
        this.virtualColumnsCount = 0;
        int n2 = 0;
        for (n = 0; n < this.realColumnsCount; ++n) {
            if (!this.columnsVisibility[n]) continue;
            this.columnsMapping[n2] = n;
            ++this.virtualColumnsCount;
            ++n2;
        }
        for (n = n2; n < this.realColumnsCount; ++n) {
            this.columnsMapping[n] = -1;
        }
        this.fireTableStructureChanged();
        this.realModel.fireTableStructureChanged();
    }
}

