/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring;

import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring.AbstractValueColor;
import java.awt.Color;
import java.util.Collection;

final class GradientColor
extends AbstractValueColor {
    private final double m_beginValue;
    private final double m_endValue;
    private final double m_diff;
    private final Color[] m_colorLookup;

    GradientColor(double baginValue, Color beginColor, double end, Color endColor, Color missingValueColor, Collection<IEventType> types, String attribteIdentifier) {
        super(types, attribteIdentifier, missingValueColor, FieldType.NUMERIC);
        this.m_beginValue = baginValue;
        this.m_endValue = end;
        this.m_diff = this.m_endValue - this.m_beginValue;
        this.m_colorLookup = this.buildLookup(beginColor, endColor, this.m_diff);
    }

    private Color[] buildLookup(Color begin, Color end, double span) {
        Color[] colors = new Color[256];
        int n = 0;
        while (n < colors.length) {
            colors[n] = this.calculateColor(begin, end, (float)n / 256.0f);
            ++n;
        }
        return colors;
    }

    private Color calculateColor(Color begin, Color end, float p) {
        return new Color((int)((float)begin.getRed() + p * (float)(end.getRed() - begin.getRed())), (int)((float)begin.getBlue() + p * (float)(end.getBlue() - begin.getBlue())), (int)((float)begin.getGreen() + p * (float)(end.getBlue() - begin.getBlue())));
    }

    @Override
    public Color getColor(IEvent e) {
        Object o = this.getEventValue(e);
        if (o instanceof Number) {
            float f = ((Number)o).floatValue();
            if ((double)f < this.m_beginValue) {
                return this.m_colorLookup[0];
            }
            if ((double)f >= this.m_endValue) {
                return this.m_colorLookup[this.m_colorLookup.length];
            }
            return this.m_colorLookup[(int)(((double)f - this.m_beginValue) / this.m_diff)];
        }
        return this.getDefaultColor();
    }
}

