/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.tab;

import com.jrockit.mc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import com.jrockit.mc.console.ui.mbeanbrowser.tab.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.MBeanTreeSectionPart;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.ConnectionClosedException;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.ui.operations.ExecuteOperationForm;
import com.jrockit.mc.ui.misc.ErrorDialog;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import java.util.Collections;
import javax.management.ObjectName;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MBeanOperationsSectionPart
extends MCClientSectionPart
implements IPartSelectionListener {
    private ExecuteOperationForm client;

    public MBeanOperationsSectionPart(Composite parent, FormToolkit toolkit, String sectionIdentifier) {
        super(parent, toolkit, 4096, sectionIdentifier);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        StructuredSelection structuredSelection;
        Object object;
        if (!selection.isEmpty() && part instanceof MBeanTreeSectionPart && (object = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof ObjectName) {
            try {
                this.client.setOperations(((IMBeanHelperService)this.getConnectionHandle().getServiceOrThrow(IMBeanHelperService.class)).getOperations((ObjectName)object));
            }
            catch (ConnectionClosedException e) {
                this.client.setOperations(Collections.emptyList());
            }
            catch (Exception e) {
                e.printStackTrace();
                String error = Messages.MBeanOperationsSectionPart_FAILED_TO_LOAD_OPERATIONS;
                ErrorDialog.showException((Shell)this.getSection().getShell(), (String)error, (String)error, (Throwable)e);
            }
        }
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)MBeanBrowserPlugin.getDefault().getMCDialogSettings(), (String)"execute_mbean_operation_form");
        SashForm sash = new SashForm(section, 512);
        this.client = new ExecuteOperationForm(sash, formToolkit, true, false, settings);
        return sash;
    }

    private IConnectionHandle getConnectionHandle() {
        return (IConnectionHandle)this.getManagedForm().getInput();
    }

    protected void initializeSection(Section section) {
    }
}

