/*
 * Decompiled with CFR 0.152.
 */
package pulferuploader;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.alfresco.cmis.client.AlfrescoDocument;
import org.alfresco.cmis.client.AlfrescoFolder;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;

public class PulferUploader {
    private static Session session;
    private static String ALFRESCO_ATOMPUB_URL;
    private static String ALFRESCO_REPOSITORY_ID;
    private static String ALFRESCO_SAP_SITE_ID;
    private static String ALFRESCO_USERNAME;
    private static String ALFRESCO_PASSWORD;
    private static String ALFRESCO_STRINGCONNECTION;
    private static String ALFRESCO_STRING_RETOUR_URL;
    private static String ALFRESCO_NOM_SITE;
    private static String CONNECTEUR_REPERTOIRE_NOEUD_ID;
    private static String TYPEDOC_NODE_ACTIF;
    private static String TYPEDOC_NODE_ARCHIVER;
    private static String TYPEDOC_PATH_ACTIF;
    private static String TYPEDOC_PATH_ARCHIVER;
    public static String APACHE_REPERTOIRE_TEMP;
    private static String argFunction;
    private static String argFunctionCreate;
    private static String argFunctionCreateOut;
    private static String argFunctionGet;
    private static String argFunctionDelete;
    private static String argFunctionInfo;
    private static String argFunctionServerInfo;
    private static String argDocId;
    private static String argDocName;
    private static String argMimeType;
    private static String argNode1_id;
    private static String argNode1_des;
    private static String argNode2_id;
    private static String argNode2_des;
    private static String argNode3_id;
    private static String argNode3_des;
    private static String argVersion;
    private static String argContentRepository;
    private static String argpVersion;
    private static String argConfigFile;
    private static String argTempPath;
    private static org.apache.chemistry.opencmis.commons.data.Properties props;
    private static GregorianCalendar docCreationDateUTC;
    private static GregorianCalendar docModificationDateUtC;
    private static String docNumberComps;
    private static String docContentRep;
    private static String docStatus;
    private static String pVersion;
    private static String pathConfigFile;
    private static String pathTempFile;
    private static String repNode1_id;
    private static String repNode1_des;
    private static String repNode2_id;
    private static String repNode2_des;
    private static String repNode3_id;
    private static String repNode3_des;
    private static Folder folderSAPDOC;

    public static void main(String[] args) {
        String Function2 = "";
        String DocNameURLEncoded = "";
        String DocName = "";
        String DocId = "";
        String MimeType = "";
        System.setErr(System.out);
        System.out.println(Integer.toString(args.length) + " arguments et valeurs trouver");
        if (args.length >= 1) {
            if (args.length == 1 && args[0].equalsIgnoreCase(argVersion)) {
                PulferUploader.version();
            } else if (args[0].equalsIgnoreCase(argFunction)) {
                Function2 = args[1];
                if (args.length >= 12 && Function2.equalsIgnoreCase(argFunctionCreate) && args[2].equalsIgnoreCase(argDocName) && args[4].equalsIgnoreCase(argDocId) && args[6].equalsIgnoreCase(argMimeType) && args[8].equalsIgnoreCase(argContentRepository) && args[10].equalsIgnoreCase(argConfigFile)) {
                    DocNameURLEncoded = args[3];
                    DocName = PulferUploader.URL_Decoding(args[3]);
                    DocId = args[5];
                    MimeType = args[7];
                    docContentRep = args[9];
                    pathConfigFile = args[11];
                    if (args.length >= 16 && args[12].equalsIgnoreCase(argNode1_id) && args[14].equalsIgnoreCase(argNode1_des)) {
                        repNode1_id = args[13];
                        repNode1_des = PulferUploader.URL_Decoding(args[15]);
                        System.out.print("repNode1_id = " + repNode1_id);
                        System.out.print("repNode1_des = " + repNode1_des);
                        if (args.length >= 20 && args[16].equalsIgnoreCase(argNode2_id) && args[18].equalsIgnoreCase(argNode2_des)) {
                            repNode2_id = args[17];
                            repNode2_des = PulferUploader.URL_Decoding(args[19]);
                            System.out.print("repNode2_id = " + repNode2_id);
                            System.out.print("repNode2_des = " + repNode2_des);
                            if (args.length >= 24 && args[20].equalsIgnoreCase(argNode3_id) && args[22].equalsIgnoreCase(argNode3_des)) {
                                repNode3_id = args[21];
                                repNode3_des = PulferUploader.URL_Decoding(args[23]);
                                System.out.print("repNode3_id = " + repNode3_id);
                                System.out.print("repNode3_des = " + repNode3_des);
                            }
                        }
                    }
                } else {
                    PulferUploader.usage();
                }
            } else {
                PulferUploader.usage();
            }
        } else {
            PulferUploader.usage();
        }
        Properties props = null;
        File configFile = null;
        FileInputStream fis = null;
        try {
            props = new Properties();
            configFile = new File(pathConfigFile);
            fis = new FileInputStream(configFile);
            props.load(fis);
            ALFRESCO_ATOMPUB_URL = props.getProperty("alfresco.cmisURL");
            ALFRESCO_REPOSITORY_ID = props.getProperty("alfresco.repositoryID");
            ALFRESCO_SAP_SITE_ID = props.getProperty("alfresco.siteSapID");
            ALFRESCO_USERNAME = props.getProperty("alfresco.username");
            ALFRESCO_PASSWORD = props.getProperty("alfresco.password");
            ALFRESCO_STRINGCONNECTION = props.getProperty("alfresco.ftp.stringConnection");
            ALFRESCO_STRING_RETOUR_URL = props.getProperty("alfresco.string.retour.url");
            ALFRESCO_NOM_SITE = props.getProperty("alfresco.nom.site");
            CONNECTEUR_REPERTOIRE_NOEUD_ID = props.getProperty("connecteur.repertoireNoeudID");
            APACHE_REPERTOIRE_TEMP = props.getProperty("apache.repertoireTemp");
            if (ALFRESCO_ATOMPUB_URL.equals("") || ALFRESCO_ATOMPUB_URL == null || ALFRESCO_PASSWORD.equals("") || ALFRESCO_PASSWORD == null || ALFRESCO_USERNAME.equals("") || ALFRESCO_USERNAME == null || ALFRESCO_REPOSITORY_ID.equals("") || ALFRESCO_REPOSITORY_ID == null || ALFRESCO_SAP_SITE_ID.equals("") || ALFRESCO_SAP_SITE_ID == null || ALFRESCO_STRINGCONNECTION.equals("") || ALFRESCO_STRINGCONNECTION == null || ALFRESCO_STRING_RETOUR_URL.equals("") || ALFRESCO_STRING_RETOUR_URL == null || ALFRESCO_NOM_SITE.equals("") || ALFRESCO_NOM_SITE == null || CONNECTEUR_REPERTOIRE_NOEUD_ID.equals("") || CONNECTEUR_REPERTOIRE_NOEUD_ID == null || APACHE_REPERTOIRE_TEMP.equals("") || APACHE_REPERTOIRE_TEMP == null) {
                System.out.println("Parametres du fichier INI incorrectes.");
                System.out.println("alfresco.cmisURL : " + ALFRESCO_ATOMPUB_URL);
                System.out.println("alfresco.repositoryID : " + ALFRESCO_REPOSITORY_ID);
                System.out.println("alfresco.siteSapID : " + ALFRESCO_SAP_SITE_ID);
                System.out.println("alfresco.username : " + ALFRESCO_USERNAME);
                System.out.println("alfresco.password : " + ALFRESCO_PASSWORD);
                System.out.println("alfresco.string.retour.url : " + ALFRESCO_STRING_RETOUR_URL);
                System.out.println("alfresco.ftp.stringConnection : " + ALFRESCO_STRINGCONNECTION);
                System.out.println("alfresco.nom.site : " + ALFRESCO_NOM_SITE);
                System.out.println("connecteur.repertoireNoeudID : " + CONNECTEUR_REPERTOIRE_NOEUD_ID);
                System.out.println("apache.repertoireTemp : " + APACHE_REPERTOIRE_TEMP);
                PulferUploader.usage();
            }
            if (!docContentRep.equalsIgnoreCase("")) {
                TYPEDOC_NODE_ACTIF = props.getProperty("typeDoc." + docContentRep + ".repertoireActif.ID");
                TYPEDOC_PATH_ACTIF = props.getProperty("typeDoc." + docContentRep + ".repertoireActif.PATH");
                if (TYPEDOC_NODE_ACTIF.equals("") || TYPEDOC_NODE_ACTIF == null || TYPEDOC_PATH_ACTIF.equals("") || TYPEDOC_PATH_ACTIF == null) {
                    System.out.println("typeDoc." + docContentRep + ".repertoireActif.ID : " + TYPEDOC_NODE_ACTIF);
                    System.out.println("typeDoc." + docContentRep + ".repertoireActif.PATH : " + TYPEDOC_PATH_ACTIF);
                    PulferUploader.usage();
                }
            }
        }
        catch (IOException ex) {
            props = null;
            fis = null;
            configFile = null;
            System.out.println("Erreur durant la lecture et le chargement des parametres dans le fichier INI.");
            PulferUploader.usage();
        }
        if (Function2.equals("create")) {
            PulferUploader.initializeConnection(false);
            if (folderSAPDOC != null) {
                System.out.println("Recuperation du repertoire actif...");
                Folder folder_ACTIF = PulferUploader.traitementRepertoires(PulferUploader.getFolderById(props.getProperty("typeDoc.repertoireClient")));
                System.out.println("Repertoire actif : " + folder_ACTIF.getName().toString());
                if (folder_ACTIF != null) {
                    System.out.println("Import du document...");
                    boolean check = PulferUploader.importDocument(folder_ACTIF, DocName, DocId, MimeType, APACHE_REPERTOIRE_TEMP);
                    if (check) {
                        try {
                            System.out.println(ALFRESCO_STRING_RETOUR_URL + URLEncoder.encode(folder_ACTIF.getPath().replaceFirst("/Sites/" + ALFRESCO_NOM_SITE + "/documentLibrary/", "") + "/", "UTF-8") + DocNameURLEncoded);
                            System.out.println("Traitement effectuer avec succes");
                            System.out.println("200");
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                            System.out.println("Erreur durant le retour du chemin d acces au fichier");
                            System.out.println("500");
                        }
                    } else {
                        System.out.println("Erreur interne");
                        System.out.println("500");
                    }
                } else {
                    System.out.println("Erreur interne");
                    System.out.println("500");
                }
                folder_ACTIF = null;
            } else {
                System.out.println("Erreur interne");
                System.out.println("500");
            }
            try {
                File temporaryFile = new File(APACHE_REPERTOIRE_TEMP + DocName);
                boolean checkDelete = temporaryFile.delete();
                temporaryFile = null;
            }
            catch (Exception e) {}
        } else {
            System.out.println("Mauvaise requete, fonction inconnue");
            System.out.println("500");
        }
        folderSAPDOC = null;
        try {
            props.clear();
            fis.close();
            props = null;
            fis = null;
            configFile = null;
        }
        catch (Exception e) {
            props = null;
            fis = null;
            configFile = null;
        }
    }

    private static String URL_Decoding(String s) {
        try {
            s = URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception ex) {
            s = "";
        }
        return s;
    }

    private static Folder traitementRepertoires(Folder mainFolder) {
        System.out.println("mainFolder : " + mainFolder.getPath());
        AlfrescoFolder alfRep = null;
        Folder actFolder = null;
        System.out.println("Traitements repertoires...");
        try {
            if (repNode1_des != "") {
                HashMap<String, String> propertiesDoc;
                if (!PulferUploader.checkFolderExist(mainFolder, repNode1_des)) {
                    actFolder = PulferUploader.createFolder(mainFolder, repNode1_des);
                    alfRep = (AlfrescoFolder)actFolder;
                    alfRep.addAspect(new String[]{"P:cm:titled"});
                    if (alfRep.hasAspect("P:cm:titled")) {
                        propertiesDoc = new HashMap<String, String>();
                        propertiesDoc.put("cm:title", repNode1_id);
                        actFolder.updateProperties(propertiesDoc);
                    }
                    alfRep = null;
                } else {
                    actFolder = (Folder)session.getObjectByPath(mainFolder.getPath() + "/" + repNode1_des);
                }
                if (repNode2_des != "") {
                    if (!PulferUploader.checkFolderExist(actFolder, repNode2_des)) {
                        actFolder = PulferUploader.createFolder(actFolder, repNode2_des);
                        alfRep = (AlfrescoFolder)actFolder;
                        alfRep.addAspect(new String[]{"P:cm:titled"});
                        if (alfRep.hasAspect("P:cm:titled")) {
                            propertiesDoc = new HashMap();
                            propertiesDoc.put("cm:title", repNode2_id);
                            actFolder.updateProperties(propertiesDoc);
                        }
                        alfRep = null;
                    } else {
                        actFolder = (Folder)session.getObjectByPath(actFolder.getPath() + "/" + repNode2_des);
                    }
                    if (repNode3_des != "") {
                        if (!PulferUploader.checkFolderExist(actFolder, repNode3_des)) {
                            actFolder = PulferUploader.createFolder(actFolder, repNode3_des);
                            alfRep = (AlfrescoFolder)actFolder;
                            alfRep.addAspect(new String[]{"P:cm:titled"});
                            if (alfRep.hasAspect("P:cm:titled")) {
                                propertiesDoc = new HashMap();
                                propertiesDoc.put("cm:title", repNode3_id);
                                actFolder.updateProperties(propertiesDoc);
                            }
                            alfRep = null;
                        } else {
                            actFolder = (Folder)session.getObjectByPath(actFolder.getPath() + "/" + repNode3_des);
                        }
                    }
                }
            }
            System.out.println("Terminer");
            return actFolder;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.out.println("Erreur durant le traitement des repertoires");
            System.out.println("500");
            return null;
        }
    }

    private static boolean checkFolderExist(Folder f, String fName) {
        Folder subFolder = null;
        try {
            System.out.println("Checking path: " + f.getPath() + "/" + fName);
            subFolder = (Folder)session.getObjectByPath(f.getPath() + "/" + fName);
            System.out.println("Folder already existed!");
            subFolder = null;
            return true;
        }
        catch (CmisObjectNotFoundException onfe) {
            subFolder = null;
            return false;
        }
    }

    private static void initializeConnection(boolean exitIfNull) {
        folderSAPDOC = PulferUploader.connect();
        if (folderSAPDOC == null) {
            System.out.println("Serveur Alfresco inaccessible.");
            System.out.println("500");
            if (exitIfNull) {
                System.exit(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkServerRepository() {
        Properties tmpprops = null;
        File configFile = null;
        FileInputStream fis = null;
        String serverTime = "00:00:00";
        String serverDate = "0000-00-00";
        String reponseDescription = "Unknown";
        String reponseCode = "500";
        try {
            tmpprops = new Properties();
            configFile = new File(pathConfigFile);
            fis = new FileInputStream(configFile);
            tmpprops.load(fis);
            GregorianCalendar gc = new GregorianCalendar();
            serverTime = PulferUploader.formattingDateTime(String.valueOf(gc.get(11)), 2) + ":" + PulferUploader.formattingDateTime(String.valueOf(gc.get(12)), 2) + ":" + PulferUploader.formattingDateTime(String.valueOf(gc.get(13)), 2);
            serverDate = PulferUploader.formattingDateTime(String.valueOf(gc.get(1)), 2) + "-" + PulferUploader.formattingDateTime(String.valueOf(gc.get(2) + 1), 2) + "-" + PulferUploader.formattingDateTime(String.valueOf(gc.get(5)), 2);
            if (folderSAPDOC == null) {
                reponseDescription = "Serveur Alfresco inaccessible.";
                System.out.println("Serveur Alfresco indisponible...");
                System.out.println("server;" + tmpprops.getProperty("fonction.serverinfo.serverStatus.Down") + ";" + tmpprops.getProperty("fonction.serverinfo.serverVendorID") + ";" + pVersion + ";" + tmpprops.getProperty("fonction.serverinfo.serverBuild") + ";" + serverTime + ";" + serverDate + ";" + tmpprops.getProperty("fonction.serverinfo.serverStatusDescription.Down") + ";" + pVersion);
            } else {
                reponseDescription = "Traitement effectuer avec succes.";
                System.out.println("Serveur Alfresco disponible...");
                System.out.println("server;" + tmpprops.getProperty("fonction.serverinfo.serverStatus.Running") + ";" + tmpprops.getProperty("fonction.serverinfo.serverVendorID") + ";" + pVersion + ";" + tmpprops.getProperty("fonction.serverinfo.serverBuild") + ";" + serverTime + ";" + serverDate + ";" + tmpprops.getProperty("fonction.serverinfo.serverStatusDescription.Running") + ";" + pVersion);
            }
            tmpprops.clear();
            fis.close();
        }
        catch (Exception e) {
            System.out.println("Erreur dans le traitement du server");
            System.out.println("Message Exeption : " + e.getMessage());
            if (folderSAPDOC == null) {
                reponseDescription = "Serveur Alfresco inaccessible.";
                System.out.println("Retour des valeurs par defaut :");
                System.out.println("server;Down;Unknown;" + pVersion + ";Unknown;" + serverTime + ";" + serverDate + ";Error;" + pVersion);
            } else {
                reponseDescription = "Traitement effectuer avec succes.";
                System.out.println("Retour des valeurs par defaut :");
                System.out.println("server;Running;Unknown;" + pVersion + ";Unknown;" + serverTime + ";" + serverDate + ";Error;" + pVersion);
            }
        }
        finally {
            tmpprops = null;
            fis = null;
            configFile = null;
        }
        if (docContentRep.equals("")) {
            PulferUploader.checkContentRepository("ZA");
            PulferUploader.checkContentRepository("ZB");
            PulferUploader.checkContentRepository("ZC");
            PulferUploader.checkContentRepository("ZD");
            PulferUploader.checkContentRepository("ZE");
            reponseCode = "200";
        } else {
            boolean checkContrep = PulferUploader.checkContentRepository(docContentRep);
            reponseCode = checkContrep ? "200" : "500";
        }
        System.out.println(reponseDescription);
        System.out.println(reponseCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkContentRepository(String _contRep) {
        System.out.println("Traitement via checkContentRepository pour " + _contRep);
        boolean isRunning = false;
        Properties tmpprops = null;
        File configFile = null;
        FileInputStream fis = null;
        try {
            tmpprops = new Properties();
            configFile = new File(pathConfigFile);
            fis = new FileInputStream(configFile);
            tmpprops.load(fis);
            String tmpRepActif = tmpprops.getProperty("typeDoc." + _contRep + ".repertoireActif.ID");
            String tmpRepArchiver = tmpprops.getProperty("typeDoc." + _contRep + ".repertoireArchiver.ID");
            if (tmpRepActif.equals("") || tmpRepActif == null || tmpRepArchiver.equals("") || tmpRepArchiver == null) {
                System.out.println("typeDoc." + _contRep + ".repertoireActif.ID : " + tmpRepActif);
                System.out.println("typeDoc." + _contRep + ".repertoireArchiver.ID : " + tmpRepArchiver);
            } else {
                Folder tmpFolderActif = null;
                Folder tmpFolderArchiver = null;
                tmpFolderActif = (Folder)session.getObject(tmpRepActif);
                tmpFolderArchiver = (Folder)session.getObject(tmpRepArchiver);
                if (tmpFolderActif != null && tmpFolderArchiver != null) {
                    isRunning = true;
                }
                tmpFolderActif = null;
                tmpFolderArchiver = null;
            }
            if (isRunning) {
                System.out.println("repository;" + _contRep + ";" + tmpprops.getProperty("fonction.serverinfo.contRepDescription." + _contRep) + ";" + tmpprops.getProperty("fonction.serverinfo.contRepStatus.Running") + ";" + tmpprops.getProperty("fonction.serverinfo.contRepStatusDescription." + _contRep) + ";" + pVersion);
            } else {
                System.out.println("repository;" + _contRep + ";" + tmpprops.getProperty("fonction.serverinfo.contRepDescription." + _contRep) + ";" + tmpprops.getProperty("fonction.serverinfo.contRepStatus.Down") + ";" + tmpprops.getProperty("fonction.serverinfo.contRepStatusDescription." + _contRep) + ";" + pVersion);
            }
            tmpprops.clear();
            fis.close();
        }
        catch (Exception e) {
            System.out.println("Erreur dans le traitement du content repository " + _contRep);
            System.out.println("Message Exeption : " + e.getMessage());
            System.out.println("Retour des valeurs par defaut :");
            System.out.println("repository;" + _contRep + ";Unknown;Down;Unknown;" + pVersion);
        }
        finally {
            tmpprops = null;
            fis = null;
            configFile = null;
        }
        return isRunning;
    }

    private static String formattingDateTime(String param, int numberDigit) {
        for (int i = param.length(); i < numberDigit; ++i) {
            param = "0" + param;
        }
        return param;
    }

    protected static void usage() {
        System.out.println("Arguments are : -function, -docid, -mimetype");
        System.out.println("The only way to use this tool is : ");
        System.out.println("\t -function theFunction -docid theDocId -mimetype theMimeType \n");
        System.out.println("Other arguments : -version");
        System.out.println("\t -version \t print the version information for this tool");
        System.out.println("Parametres incorrectes");
        System.out.println("500");
        System.exit(1);
    }

    protected static void version() {
        System.out.println("");
        System.out.println("fUploader v. 0.0.0.1 beta");
        System.out.println("");
        System.exit(0);
    }

    private static int searchDocument(String _docId, boolean _withParent) {
        block19: {
            try {
                File tmpID = new File(CONNECTEUR_REPERTOIRE_NOEUD_ID + _docId + ".txt");
                if (tmpID.exists()) {
                    System.out.println("Recherche via noeud ID du document " + _docId + " dans Alfresco");
                    FileInputStream fis = new FileInputStream(tmpID);
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.forName("UTF-8")));
                    String nodeID = br.readLine();
                    br.close();
                    br = null;
                    fis = null;
                    Document tmpDoc = null;
                    tmpDoc = (Document)session.getObject(nodeID);
                    if (tmpDoc == null) {
                        System.out.println("Erreur - Aucun document trouver.");
                        tmpID = null;
                        tmpDoc = null;
                        return 404;
                    }
                    System.out.println("Le document trouver est " + tmpDoc.getName());
                    try {
                        System.out.println("Recuperation date creation...");
                        docCreationDateUTC = tmpDoc.getCreationDate();
                        System.out.println("Recuperation date modification...");
                        docModificationDateUtC = tmpDoc.getLastModificationDate();
                    }
                    catch (Exception e) {
                        System.out.println("Erreur recuperation date :" + e.getMessage());
                    }
                    if (_withParent) {
                        String parentID = ((Folder)tmpDoc.getParents().get(0)).getId();
                        System.out.println("parent ID : " + parentID);
                        if (TYPEDOC_NODE_ACTIF.equals(parentID)) {
                            System.out.println(ALFRESCO_STRINGCONNECTION + TYPEDOC_PATH_ACTIF + _docId);
                        } else if (TYPEDOC_NODE_ARCHIVER.equals(parentID)) {
                            System.out.println(ALFRESCO_STRINGCONNECTION + TYPEDOC_PATH_ARCHIVER + _docId);
                        } else {
                            System.out.println("parent ID introuvable");
                            return 500;
                        }
                    }
                    System.out.println(tmpDoc.getPropertyValue("cmis:contentStreamMimeType").toString());
                    tmpID = null;
                    tmpDoc = null;
                    return 200;
                }
                System.out.println("Recherche dynamique du document " + _docId + " dans Alfresco");
                ItemIterable results = session.query("SELECT * FROM cmis:document WHERE cmis:name='" + _docId + "'", false);
                System.out.println("Parcour du resultat de la recherche...");
                if (Integer.valueOf(String.valueOf(results.getTotalNumItems())) == 1) {
                    System.out.println("1 document trouver");
                    System.out.println("Recuperation et controle des informations du document trouver");
                    Iterator i$ = results.iterator();
                    if (i$.hasNext()) {
                        QueryResult hit = (QueryResult)i$.next();
                        String objId = "";
                        String mimeType = "";
                        objId = hit.getPropertyValueById("cmis:objectId").toString();
                        mimeType = hit.getPropertyValueById("cmis:contentStreamMimeType").toString();
                        Document docResearch = (Document)session.getObject(objId);
                        docCreationDateUTC = docResearch.getCreationDate();
                        docModificationDateUtC = docResearch.getLastModificationDate();
                        if (_withParent) {
                            String parentID = ((Folder)docResearch.getParents().get(0)).getId();
                            System.out.println("parent ID : " + parentID);
                            if (TYPEDOC_NODE_ACTIF.equals(parentID)) {
                                System.out.println(ALFRESCO_STRINGCONNECTION + TYPEDOC_PATH_ACTIF + _docId);
                            } else if (TYPEDOC_NODE_ARCHIVER.equals(parentID)) {
                                System.out.println(ALFRESCO_STRINGCONNECTION + TYPEDOC_PATH_ARCHIVER + _docId);
                            } else {
                                System.out.println("parent ID introuvable");
                                return 500;
                            }
                        }
                        docResearch = null;
                        System.out.println(mimeType);
                        return 200;
                    }
                    break block19;
                }
                if (Integer.valueOf(String.valueOf(results.getTotalNumItems())) == 0) {
                    GregorianCalendar gca = new GregorianCalendar();
                    System.out.println(String.valueOf(gca.get(11) + ":" + String.valueOf(gca.get(12)) + ":" + String.valueOf(gca.get(13))) + " : Aucun document trouver");
                    gca = null;
                    return 404;
                }
                System.out.println("Plusieurs documents ont etes trouver");
                return 500;
            }
            catch (Exception e) {
                System.out.println("Erreur de traitement catcher");
                System.out.println("error=" + e.toString());
                return 500;
            }
        }
        System.out.println("Erreur inconnue");
        return 500;
    }

    private static int deleteSearchFolder(String _docId) {
        block6: {
            try {
                ItemIterable results = session.query("SELECT * FROM cmis:folder WHERE cmis:name='" + _docId + "'", false);
                if (Integer.valueOf(String.valueOf(results.getTotalNumItems())) == 1) {
                    Iterator i$ = results.iterator();
                    if (i$.hasNext()) {
                        QueryResult hit = (QueryResult)i$.next();
                        String objId = "";
                        objId = hit.getPropertyValueById("cmis:objectId").toString();
                        Folder toDelete = (Folder)session.getObject(objId);
                        List errorDelete = toDelete.deleteTree(true, UnfileObject.UNFILE, true);
                        System.out.println("--------------------------------------");
                        if (errorDelete.isEmpty()) {
                            return 200;
                        }
                        return 409;
                    }
                    break block6;
                }
                if (Integer.valueOf(String.valueOf(results.getTotalNumItems())) == 0) {
                    return 404;
                }
                return 500;
            }
            catch (Exception e) {
                return 500;
            }
        }
        return 500;
    }

    private static int disabledSearchDocument(String _docId, Folder _folderSource, Folder _folderDestination) {
        block10: {
            try {
                File tmpID = new File(CONNECTEUR_REPERTOIRE_NOEUD_ID + _docId + ".txt");
                if (tmpID.exists()) {
                    System.out.println("Desactivation du document via noeud ID : " + _docId);
                    FileInputStream fis = new FileInputStream(tmpID);
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.forName("UTF-8")));
                    String nodeID = br.readLine();
                    br.close();
                    br = null;
                    fis = null;
                    Document tmpDoc = null;
                    tmpDoc = (Document)session.getObject(nodeID);
                    System.out.println("--------------------------------------");
                    try {
                        FileableCmisObject fco = tmpDoc.move((ObjectId)_folderSource, (ObjectId)_folderDestination);
                        return 200;
                    }
                    catch (Exception e) {
                        return 409;
                    }
                }
                System.out.println("Desactivation du document via recherche dynamique : " + _docId);
                ItemIterable results = session.query("SELECT * FROM cmis:document WHERE cmis:name='" + _docId + "'", false);
                if (Integer.valueOf(String.valueOf(results.getTotalNumItems())) == 1) {
                    Iterator i$ = results.iterator();
                    if (i$.hasNext()) {
                        QueryResult hit = (QueryResult)i$.next();
                        String objId = "";
                        objId = (String)hit.getPropertyValueById("cmis:objectId");
                        Document toDisabled = (Document)session.getObject(objId);
                        System.out.println("--------------------------------------");
                        try {
                            FileableCmisObject fco = toDisabled.move((ObjectId)_folderSource, (ObjectId)_folderDestination);
                            return 200;
                        }
                        catch (Exception e) {
                            return 409;
                        }
                    }
                    break block10;
                }
                if (Integer.valueOf(String.valueOf(results.getTotalNumItems())) == 0) {
                    return 404;
                }
                return 500;
            }
            catch (Exception e) {
                return 500;
            }
        }
        return 500;
    }

    private static byte[] testReadByteFile(File file) {
        try {
            int result;
            FileInputStream in = new FileInputStream(file);
            int fLength = Integer.valueOf(String.valueOf(file.length()));
            byte[] b = new byte[fLength];
            int len = b.length;
            for (int total = 0; total < len && (result = ((InputStream)in).read(b, total, len - total)) != -1; total += result) {
            }
            return b;
        }
        catch (Exception e) {
            System.out.println("Erreur durant la recuperation du contenu du fichier sous forme de tableau de bytes.");
            System.out.println("Message : " + e.getMessage());
            return null;
        }
    }

    private static boolean importDocument(Folder target, String newDocName, String docId, String mimetype, String pathTempRep) {
        try {
            System.out.println("Debut de l import...");
            File file = new File(pathTempRep + newDocName);
            if (file != null) {
                boolean check = PulferUploader.createDocumentWithContentByte(target, newDocName, docId, PulferUploader.testReadByteFile(file), mimetype);
                file = null;
                return check;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean createDocumentWithContentByte(Folder target, String newDocName, String docId, byte[] buffer, String mimetype) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cmis:objectTypeId", "cmis:document");
        props.put("cmis:name", newDocName);
        ByteArrayInputStream input = new ByteArrayInputStream(buffer);
        ContentStream contentStream = session.getObjectFactory().createContentStream(newDocName, (long)buffer.length, mimetype, (InputStream)input);
        Document doc = null;
        doc = target.createDocument(props, contentStream, VersioningState.MAJOR);
        try {
            if (doc != null) {
                AlfrescoDocument alfDoc = (AlfrescoDocument)doc;
                alfDoc.addAspect(new String[]{"P:cm:titled"});
                if (alfDoc.hasAspect("P:cm:titled")) {
                    HashMap<String, String> propertiesDoc = new HashMap<String, String>();
                    propertiesDoc.put("cm:title", docId);
                    doc.updateProperties(propertiesDoc);
                }
                System.out.println("Le document " + newDocName + " a ete creer avec succes dans Alfresco");
                System.out.println("mimetype=" + doc.getContentStreamMimeType());
                doc = null;
                return true;
            }
            System.out.println("Erreur - Le document " + newDocName + " n a pas ete creer dans Alfresco.");
            System.out.println("500");
            return false;
        }
        catch (Exception e) {
            try {
                System.out.println("Erreur lors de l enregistrement de l ID.");
                System.out.println("Message : " + e.getMessage());
                System.out.println("Erreur lors de la recuperation de l ID du noeud.");
                System.out.println("500");
                return false;
            }
            catch (Exception e2) {
                System.out.println("Erreur interne");
                System.out.println("500");
                return false;
            }
        }
    }

    private static Folder createFolder(Folder target, String newFolderName) {
        try {
            System.out.println(target.getName());
            System.out.println("Debut create folder:" + newFolderName);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("cmis:objectTypeId", "cmis:folder");
            props.put("cmis:name", newFolderName);
            Folder newFolder = target.createFolder(props);
            System.out.println("Repertoire " + newFolderName + " creer.");
            return newFolder;
        }
        catch (Exception e) {
            System.out.println("Erreur pendant la creation du repertoire:" + newFolderName);
            e.printStackTrace();
            return null;
        }
    }

    private static Folder connect() {
        try {
            SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("org.apache.chemistry.opencmis.user", ALFRESCO_USERNAME);
            parameter.put("org.apache.chemistry.opencmis.password", ALFRESCO_PASSWORD);
            parameter.put("org.apache.chemistry.opencmis.binding.atompub.url", ALFRESCO_ATOMPUB_URL);
            parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            parameter.put("org.apache.chemistry.opencmis.session.repository.id", ALFRESCO_REPOSITORY_ID);
            parameter.put("org.apache.chemistry.opencmis.objectfactory.classname", "org.alfresco.cmis.client.impl.AlfrescoObjectFactoryImpl");
            session = sessionFactory.createSession(parameter);
            return PulferUploader.getFolderById(ALFRESCO_SAP_SITE_ID);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Folder getFolderById(String repId) {
        try {
            CmisObject o = session.getObject(repId);
            return (Folder)o;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        ALFRESCO_ATOMPUB_URL = "";
        ALFRESCO_REPOSITORY_ID = "";
        ALFRESCO_SAP_SITE_ID = "";
        ALFRESCO_USERNAME = "";
        ALFRESCO_PASSWORD = "";
        ALFRESCO_STRINGCONNECTION = "";
        ALFRESCO_STRING_RETOUR_URL = "";
        ALFRESCO_NOM_SITE = "";
        CONNECTEUR_REPERTOIRE_NOEUD_ID = "";
        TYPEDOC_NODE_ACTIF = "";
        TYPEDOC_NODE_ARCHIVER = "";
        TYPEDOC_PATH_ACTIF = "";
        TYPEDOC_PATH_ARCHIVER = "";
        APACHE_REPERTOIRE_TEMP = "";
        argFunction = "-function";
        argFunctionCreate = "create";
        argFunctionCreateOut = "createOut";
        argFunctionGet = "get";
        argFunctionDelete = "delete";
        argFunctionInfo = "info";
        argFunctionServerInfo = "serverinfo";
        argDocId = "-docid";
        argDocName = "-docname";
        argMimeType = "-mimetype";
        argNode1_id = "-node1_id";
        argNode1_des = "-node1_des";
        argNode2_id = "-node2_id";
        argNode2_des = "-node2_des";
        argNode3_id = "-node3_id";
        argNode3_des = "-node3_des";
        argVersion = "-version";
        argContentRepository = "-contentRep";
        argpVersion = "-pVersion";
        argConfigFile = "-configFile";
        argTempPath = "-tmpPath";
        docCreationDateUTC = null;
        docModificationDateUtC = null;
        docNumberComps = "";
        docContentRep = "";
        docStatus = "";
        pVersion = "";
        pathConfigFile = "";
        pathTempFile = "";
        repNode1_id = "";
        repNode1_des = "";
        repNode2_id = "";
        repNode2_des = "";
        repNode3_id = "";
        repNode3_des = "";
        folderSAPDOC = null;
    }
}

